#!/usr/bin/perl

# This script extracts the values for the locale variables
# "decimal_point","mon_decimal_point","thousands_sep","mon_thousands_sep"
# and checks if their numeric setting differs from the
# one used for currencies.
#
# It prints the ones where it differs including the settings
#
# At the end the number of processed and matched locales is printed
my @keywords = ("decimal_point","mon_decimal_point","thousands_sep","mon_thousands_sep");
my $processed = 0;
my $differing = 0;

print "Locale";
foreach $k ("dp", "mon_dp", "sep", "mon_sep") {
    print "\t$k"
}
print "\n";

open(LOCALES, "locale -a |") or die;
while(<LOCALES>) {
    chomp $_;
    my $localeName = $_;
    # filter out locale names without a special meaning
    if ($localeName =~ /.+\@.+/ || $localeName =~ /.+\.utf8/) {
        $processed++;
        $_ =~ /(^[^\.]+)/;
        my $locale = $1;
        open(VALUES, "LC_ALL=$localeName locale -k decimal_point mon_decimal_point thousands_sep mon_thousands_sep 2> /dev/null |") or die;
        my %values = {};

        while (<VALUES>) {
            chomp $_;
            foreach $k (@keywords) {
                if ($_ =~ /^$k="(.*)"$/) {
                    $values{$k} = $1;
                    $values{$k} = "<>" if ($1 eq "");
                    $values{$k} = "_" if ($1 eq " ");
                }
            }
        }
        if (($values{'decimal_point'} ne $values{'mon_decimal_point'})
         || ($values{'thousands_sep'} ne $values{'mon_thousands_sep'}))
        {
            $differing++;
            print "$localeName";
            foreach $k (@keywords) {
                print "\t$values{$k}"
            }
            # mark those entries, where both characters differ
            print " *" if (($values{'decimal_point'} ne $values{'mon_decimal_point'})
             && ($values{'thousands_sep'} ne $values{'mon_thousands_sep'}));
            print "\n";
        }
        close VALUES;
    }
}
close LOCALES;

print "$processed locales processed, $differing locales differ.\n";
